/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.function.Predicate;

class Board {
    private boolean gameOver = false;
    private boolean gravity = true;
    private int numClearedLines = 0;
    private int level = 0;
    private int score = 0;
    private int timePerBlock = 800;
    private List<Point> points = new ArrayList<Point>();
    private Random rand = new Random();
    private Shape currentShape;
    public static final int WIDTH = 10;
    public static final int HEIGHT = 22;

    public Board() {
        this.createCurrentShape();
    }

    public void createCurrentShape() {
        int num = this.rand.nextInt(8);
        if (num == 7 || this.currentShape != null && num == this.currentShape.getType()) {
            num = this.rand.nextInt(7);
        }
        if (this.currentShape != null) {
            this.points.addAll(this.currentShape.getPoints());
        }
        this.currentShape = new Shape(num + 1);
    }

    private boolean hasPointsDown() {
        for (Point i : this.currentShape.getPoints()) {
            if (!this.points.contains(new Point(i.getX(), i.getY() + 1))) continue;
            return true;
        }
        return false;
    }

    private boolean hasPointsRight() {
        for (Point i : this.currentShape.getPoints()) {
            if (!this.points.contains(new Point(i.getX() + 1, i.getY()))) continue;
            return true;
        }
        return false;
    }

    private boolean hasPointsLeft() {
        for (Point i : this.currentShape.getPoints()) {
            if (!this.points.contains(new Point(i.getX() - 1, i.getY()))) continue;
            return true;
        }
        return false;
    }

    private boolean closeToTopBorder() {
        for (Point i : this.currentShape.getPoints()) {
            if (i.getY() != 0) continue;
            return true;
        }
        return false;
    }

    private boolean closeToLeftBorder() {
        for (Point i : this.currentShape.getPoints()) {
            if (i.getX() != 0) continue;
            return true;
        }
        return false;
    }

    private boolean closeToRightBorder() {
        for (Point i : this.currentShape.getPoints()) {
            if (i.getX() != 9) continue;
            return true;
        }
        return false;
    }

    private boolean closeToBottomBorder() {
        for (Point i : this.currentShape.getPoints()) {
            if (i.getY() != 21) continue;
            return true;
        }
        return false;
    }

    private boolean canRotate() {
        List<Point> rotated = this.currentShape.getRotatePoints();
        for (Point i : rotated) {
            if (i.getX() < 10 && i.getY() < 22 && i.getX() >= 0 && i.getY() >= 0 && !this.points.contains(i)) continue;
            return false;
        }
        return true;
    }

    public void rotate() {
        if (this.canRotate()) {
            this.currentShape.rotate();
        }
    }

    public void moveLeft() {
        if (!this.hasPointsLeft() && !this.closeToLeftBorder()) {
            this.currentShape.moveLeft();
        }
    }

    public void moveRight() {
        if (!this.hasPointsRight() && !this.closeToRightBorder()) {
            this.currentShape.moveRight();
        }
    }

    public void moveDown() {
        if (!this.hasPointsDown() && !this.closeToBottomBorder()) {
            this.currentShape.moveDown();
        } else if (this.closeToTopBorder()) {
            this.gameOver = true;
        } else {
            this.createCurrentShape();
            this.removeLines();
        }
    }

    private void removeLines() {
        boolean gravityTriggerd;
        do {
            int i;
            gravityTriggerd = false;
            ArrayList<Integer> fullLines = new ArrayList<Integer>(22);
            List<Point> allPoints = this.getPoints();
            if (allPoints.size() != 0) {
                int i2 = 0;
                while (i2 < 22) {
                    boolean full = true;
                    int j = 0;
                    while (j < 10) {
                        if (!allPoints.contains(new Point(j, i2))) {
                            full = false;
                            break;
                        }
                        ++j;
                    }
                    if (full) {
                        fullLines.add(i2);
                    }
                    ++i2;
                }
            }
            if (fullLines.size() == 0) continue;
            this.numClearedLines += fullLines.size();
            this.score += this.calculateCurrentScore(fullLines.size());
            int mostBottomLine = 0;
            Iterator j = fullLines.iterator();
            while (j.hasNext()) {
                i = (Integer)j.next();
                if (i > mostBottomLine) {
                    mostBottomLine = i;
                }
                Predicate<Point> pointsPredicate = p -> p.getY() == i;
                this.points.removeIf(pointsPredicate);
                int j2 = 0;
                while (j2 < this.points.size()) {
                    if (this.points.get(j2).getY() < i) {
                        this.points.get(j2).modY(1);
                    }
                    ++j2;
                }
            }
            if (mostBottomLine == 21 || !this.gravity) continue;
            allPoints = this.getPoints();
            i = 0;
            while (i < 10) {
                int numOfEmpty = 0;
                int j3 = mostBottomLine + 1;
                while (j3 < 22) {
                    if (allPoints.contains(new Point(i, j3))) break;
                    ++numOfEmpty;
                    ++j3;
                }
                if (numOfEmpty != 0) {
                    gravityTriggerd = false;
                    j3 = 0;
                    while (j3 < this.points.size()) {
                        if (this.points.get(j3).getX() == i && this.points.get(j3).getY() <= mostBottomLine) {
                            this.points.get(j3).modY(numOfEmpty);
                            gravityTriggerd = true;
                        }
                        ++j3;
                    }
                }
                ++i;
            }
        } while (gravityTriggerd);
        this.level = this.numClearedLines / 10;
        this.updateSpeed();
    }

    private int calculateCurrentScore(int num) {
        int baseNum = 40;
        if (num == 2) {
            baseNum = 100;
        } else if (num == 3) {
            baseNum = 300;
        } else if (num == 4) {
            baseNum = 1000;
        }
        return baseNum * (this.level + 1);
    }

    private void updateSpeed() {
        double baseFrame = 48.0;
        this.timePerBlock = -1 < this.level && this.level < 9 ? (int)((baseFrame - (double)this.level * 5.0) / 60.0 * 1000.0) : (this.level == 9 ? 100 : (9 < this.level && this.level < 19 ? 66 : (18 < this.level && this.level < 29 ? 33 : 16)));
    }

    public List<Point> getPoints() {
        ArrayList<Point> points = new ArrayList<Point>();
        points.addAll(this.points);
        points.addAll(this.currentShape.getPoints());
        HashSet<Point> set = new HashSet<Point>();
        set.addAll(points);
        points.clear();
        points.addAll(set);
        return points;
    }

    public void getStatus() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.toString());
        sb.append("--- Border ---\n");
        sb.append("Left " + this.closeToLeftBorder() + "\n");
        sb.append("Right " + this.closeToRightBorder() + "\n");
        sb.append("Bottom " + this.closeToBottomBorder() + "\n");
        sb.append("--- Points ---\n");
        sb.append("Left " + this.hasPointsLeft() + "\n");
        sb.append("Right " + this.hasPointsRight() + "\n");
        sb.append("Bottom " + this.hasPointsDown() + "\n");
        sb.append("--- Rotate ---\n");
        sb.append(this.canRotate());
        System.out.println(sb.toString());
    }

    public int getNumClearedLines() {
        return this.numClearedLines;
    }

    public boolean getGravity() {
        return this.gravity;
    }

    public void setGravity(boolean gravity) {
        this.gravity = gravity;
    }

    public boolean getGameOver() {
        return this.gameOver;
    }

    public int getLevel() {
        return this.level;
    }

    public int getTimePerBlock() {
        return this.timePerBlock;
    }

    public int getScore() {
        return this.score;
    }

    public String toString() {
        int[][] board = new int[22][10];
        for (Point i : this.points) {
            board[i.getY()][i.getX()] = i.getType();
        }
        for (Point i : this.currentShape.getPoints()) {
            board[i.getY()][i.getX()] = this.currentShape.getType();
        }
        String str = "";
        int[][] nArray = board;
        int n = board.length;
        int n2 = 0;
        while (n2 < n) {
            int[] i = nArray[n2];
            str = String.valueOf(str) + Arrays.toString(i) + "\n";
            ++n2;
        }
        return str;
    }
}

