/*
 * Decompiled with CFR 0.152.
 */
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.PauseTransition;
import javafx.animation.SequentialTransition;
import javafx.animation.Timeline;
import javafx.application.Application;
import javafx.beans.value.WritableValue;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.KeyCode;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.RowConstraints;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.media.Media;
import javafx.scene.media.MediaPlayer;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Arc;
import javafx.scene.shape.ArcType;
import javafx.scene.shape.Polygon;
import javafx.scene.shape.Rectangle;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;
import javafx.scene.text.TextAlignment;
import javafx.stage.Stage;
import javafx.util.Duration;

public class Main
extends Application {
    private Arc halfCircle;
    private Board board;
    private boolean pressed;
    private boolean running;
    private boolean gameOver;
    private BorderPane borderPane;
    private BorderPane pauseCenter;
    private BorderPane gameOverCenter;
    private CheckBox checkGravity;
    private CheckBox checkSound;
    private CheckBox checkColor;
    private double shadeThick;
    private GridPane tetrisGrid;
    private Group cellGroup;
    private HBox root;
    private ImageView pauseImg;
    private ImageView gameOverImg;
    private int colorChoice;
    private int shapeSpeed;
    private Label subScore;
    private Label subLevel;
    private Label subLine;
    private Label score;
    private Label line;
    private Label level;
    private Label spacePause;
    private Label gameOverTitle;
    private Label gameOverSub;
    private List<Point> points;
    private Map<Integer, Color> color1;
    private Map<Integer, Color> color2;
    private Map<Integer, Map<Integer, Color>> colors;
    private MediaPlayer mainThemePlayer;
    private MediaPlayer soundEffectPlayer;
    private PauseTransition pauseTransition;
    private Point currentPoint;
    private Polygon topShade;
    private Polygon bottomShade;
    private Rectangle boardShade;
    private Rectangle square;
    private Rectangle topRec;
    private Scene scene;
    private SequentialTransition shapeTransition;
    private StackPane stackPane;
    private Stage stage;
    private Timeline musicTimeline;
    private VBox vboxTop;
    private VBox vboxBottom;
    private VBox gameOverVbox;
    private static final int PIXEL = 30;
    private static final int musicFadeInMilli = 400;
    private static final int musicFadeOutMilli = 200;

    public static void playTerminal() {
        Board board = new Board();
        Scanner reader = new Scanner(System.in);
        while (!board.getGameOver()) {
            int i;
            System.out.println(board);
            String in = reader.nextLine();
            if (!(in.contains("a") | in.contains("s")) && !in.contains("d") && !in.contains("w")) continue;
            if (in.contains("a")) {
                i = 0;
                while (i < in.length()) {
                    board.moveLeft();
                    ++i;
                }
                continue;
            }
            if (in.contains("s")) {
                i = 0;
                while (i < in.length()) {
                    board.moveDown();
                    ++i;
                }
                continue;
            }
            if (in.contains("d")) {
                i = 0;
                while (i < in.length()) {
                    board.moveRight();
                    ++i;
                }
                continue;
            }
            board.rotate();
        }
        reader.close();
    }

    public void paint() {
        if (!this.board.getGameOver()) {
            if (this.checkSound.isSelected() && this.mainThemePlayer.getStatus() == MediaPlayer.Status.PAUSED) {
                this.playMusic();
            }
            if (this.shapeSpeed != this.board.getTimePerBlock()) {
                this.shapeTransition.stop();
                this.createTransition();
            }
            this.score.setText(String.valueOf(this.board.getScore()));
            this.line.setText(String.valueOf(this.board.getNumClearedLines()));
            this.level.setText(String.valueOf(this.board.getLevel()));
            this.points = this.board.getPoints();
            this.tetrisGrid.getChildren().clear();
            int i = 0;
            while (i < 22) {
                int j = 0;
                while (j < 10) {
                    this.currentPoint = new Point(j, i);
                    this.cellGroup = new Group();
                    this.square = new Rectangle(30.0, 30.0);
                    this.topShade = new Polygon();
                    this.bottomShade = new Polygon();
                    this.shadeThick = 4.0;
                    if (this.points.contains(this.currentPoint)) {
                        this.topShade.setOpacity(0.5);
                        this.topShade.setFill((Paint)Color.WHITE);
                        this.topShade.getPoints().addAll((Object[])new Double[]{0.0, 0.0, 30.0, 0.0, 30.0 - this.shadeThick, this.shadeThick, this.shadeThick, this.shadeThick, this.shadeThick, 30.0 - this.shadeThick, 0.0, 30.0});
                        this.bottomShade.setOpacity(0.5);
                        this.bottomShade.setFill((Paint)Color.BLACK);
                        this.bottomShade.getPoints().addAll((Object[])new Double[]{0.0, 30.0, 30.0, 30.0, 30.0, 0.0, 30.0 - this.shadeThick, this.shadeThick, 30.0 - this.shadeThick, 30.0 - this.shadeThick, this.shadeThick, 30.0 - this.shadeThick});
                        this.square.setFill((Paint)this.colors.get(this.colorChoice).get(this.points.get(this.points.indexOf(this.currentPoint)).getType()));
                        this.cellGroup.getChildren().addAll((Object[])new Node[]{this.square, this.topShade, this.bottomShade});
                    } else {
                        this.topShade.setOpacity(0.1);
                        this.topShade.setFill((Paint)Color.BLACK);
                        this.topShade.getPoints().addAll((Object[])new Double[]{0.0, 0.0, 30.0, 0.0, 30.0 - this.shadeThick, this.shadeThick, this.shadeThick, this.shadeThick, this.shadeThick, 30.0 - this.shadeThick, 0.0, 30.0});
                        this.bottomShade.setOpacity(0.25);
                        this.bottomShade.setFill((Paint)Color.BLACK);
                        this.bottomShade.getPoints().addAll((Object[])new Double[]{0.0, 30.0, 30.0, 30.0, 30.0, 0.0, 30.0 - this.shadeThick, this.shadeThick, 30.0 - this.shadeThick, 30.0 - this.shadeThick, this.shadeThick, 30.0 - this.shadeThick});
                        this.topRec = new Rectangle(30.0, 11.320754716981133);
                        this.topRec.setOpacity(0.05);
                        this.topRec.setFill((Paint)Color.WHITE);
                        this.halfCircle = new Arc(15.0, 15.0, 15.0, 3.75, 0.0, 180.0);
                        this.halfCircle.setOpacity(0.05);
                        this.halfCircle.setFill((Paint)Color.WHITE);
                        this.halfCircle.setType(ArcType.ROUND);
                        this.halfCircle.setRotate(180.0);
                        this.square.setFill((Paint)Color.GRAY);
                        this.square.setOpacity(0.8870967741935484 - ((double)i + 30.0) / 72.0);
                        this.cellGroup.getChildren().addAll((Object[])new Node[]{this.square, this.topShade, this.bottomShade, this.halfCircle, this.topRec});
                    }
                    this.tetrisGrid.add((Node)this.cellGroup, j, i);
                    ++j;
                }
                ++i;
            }
        } else {
            this.gameOver = true;
            this.running = false;
            this.setSceneDisable(true);
            this.shapeTransition.stop();
            this.stopMusic();
            if (this.checkSound.isSelected()) {
                this.soundEffectPlayer.play();
            }
            this.gameOverImg = new ImageView(new Image(((Object)((Object)this)).getClass().getResource("/resources/gameOver.png").toExternalForm()));
            this.gameOverTitle = new Label("GAME OVER");
            this.gameOverTitle.setTextFill((Paint)Color.WHITE);
            this.gameOverTitle.setFont(Font.font((String)"Segoe UI", (FontWeight)FontWeight.BOLD, (double)15.0));
            this.gameOverTitle.setTextAlignment(TextAlignment.CENTER);
            this.gameOverSub = new Label("You made " + this.board.getScore() + " points\nand reached level " + this.board.getLevel() + "!");
            this.gameOverSub.setTextFill((Paint)Color.WHITE);
            this.gameOverSub.setFont(Font.font((String)"Segoe UI Semilight", (double)13.0));
            this.gameOverSub.setTextAlignment(TextAlignment.CENTER);
            this.gameOverVbox = new VBox();
            this.gameOverVbox.getChildren().addAll((Object[])new Node[]{this.gameOverImg, this.gameOverTitle, this.gameOverSub});
            this.gameOverVbox.setAlignment(Pos.CENTER);
            this.gameOverCenter = new BorderPane();
            this.gameOverCenter.setCenter((Node)this.gameOverVbox);
            this.stackPane.getChildren().addAll((Object[])new Node[]{this.boardShade, this.gameOverCenter});
        }
    }

    public void start(Stage primaryStage) {
        this.colorChoice = 0;
        this.colors = new HashMap<Integer, Map<Integer, Color>>();
        this.color1 = new HashMap<Integer, Color>();
        this.color1.put(1, Color.ORANGE);
        this.color1.put(2, Color.CYAN);
        this.color1.put(3, Color.PURPLE);
        this.color1.put(4, Color.GREEN);
        this.color1.put(5, Color.RED);
        this.color1.put(6, Color.BLUE);
        this.color1.put(7, Color.YELLOW);
        this.colors.put(0, this.color1);
        this.color2 = new HashMap<Integer, Color>();
        this.color2.put(1, Color.rgb((int)248, (int)121, (int)41));
        this.color2.put(2, Color.rgb((int)11, (int)165, (int)223));
        this.color2.put(3, Color.rgb((int)192, (int)58, (int)180));
        this.color2.put(4, Color.rgb((int)135, (int)212, (int)47));
        this.color2.put(5, Color.rgb((int)215, (int)23, (int)53));
        this.color2.put(6, Color.rgb((int)44, (int)87, (int)220));
        this.color2.put(7, Color.rgb((int)251, (int)187, (int)49));
        this.colors.put(1, this.color2);
        this.mainThemePlayer = new MediaPlayer(new Media(((Object)((Object)this)).getClass().getResource("/resources/Tetris.mp3").toExternalForm()));
        this.mainThemePlayer.setOnEndOfMedia(() -> this.mainThemePlayer.seek(Duration.ZERO));
        this.soundEffectPlayer = new MediaPlayer(new Media(((Object)((Object)this)).getClass().getResource("/resources/gameOver.mp3").toExternalForm()));
        primaryStage.getIcons().add((Object)new Image(((Object)((Object)this)).getClass().getResource("/resources/tetris.png").toExternalForm()));
        this.tetrisGrid = new GridPane();
        this.tetrisGrid.getStyleClass().add((Object)"grid");
        this.tetrisGrid.getStyleClass().add((Object)"background");
        int i = 0;
        while (i < 10) {
            this.tetrisGrid.getColumnConstraints().add((Object)new ColumnConstraints(30.0));
            ++i;
        }
        i = 0;
        while (i < 22) {
            this.tetrisGrid.getRowConstraints().add((Object)new RowConstraints(30.0));
            ++i;
        }
        this.vboxBottom = new VBox();
        this.vboxBottom.getStyleClass().add((Object)"background");
        this.score = new Label();
        this.level = new Label();
        this.line = new Label();
        this.score.getStyleClass().add((Object)"score");
        this.level.getStyleClass().add((Object)"score");
        this.line.getStyleClass().add((Object)"score");
        this.subScore = new Label("score");
        this.subLevel = new Label("level");
        this.subLine = new Label("lines cleared");
        this.subScore.getStyleClass().add((Object)"subScore");
        this.subLevel.getStyleClass().add((Object)"subScore");
        this.subLine.getStyleClass().add((Object)"subScore");
        this.vboxTop = new VBox();
        this.vboxTop.getStyleClass().add((Object)"background");
        this.vboxTop.getChildren().addAll((Object[])new Node[]{this.score, this.subScore, this.level, this.subLevel, this.line, this.subLine});
        this.checkGravity = new CheckBox("gravity");
        this.checkGravity.setSelected(true);
        this.checkGravity.focusedProperty().addListener((observable, oldValue, newValue) -> {
            if (newValue.booleanValue()) {
                this.root.requestFocus();
            }
        });
        this.checkGravity.selectedProperty().addListener((observable, oldValue, newValue) -> {
            this.board.setGravity((boolean)newValue);
            this.checkGravity.setSelected(newValue.booleanValue());
        });
        this.checkSound = new CheckBox("music");
        this.checkSound.setSelected(true);
        this.checkSound.focusedProperty().addListener((observable, oldValue, newValue) -> {
            if (newValue.booleanValue()) {
                this.root.requestFocus();
            }
        });
        this.checkSound.selectedProperty().addListener((observable, oldValue, newValue) -> {
            if (newValue.booleanValue()) {
                this.playMusic();
            } else {
                this.stopMusic();
            }
        });
        this.checkColor = new CheckBox("original colors");
        this.checkColor.setSelected(true);
        this.checkColor.focusedProperty().addListener((observable, oldValue, newValue) -> {
            if (newValue.booleanValue()) {
                this.root.requestFocus();
            }
        });
        this.checkColor.selectedProperty().addListener((observable, oldValue, newValue) -> {
            this.colorChoice = (this.colorChoice + 1) % 2;
            this.paint();
        });
        this.spacePause = new Label("press space to pause");
        this.spacePause.getStyleClass().add((Object)"pause");
        this.vboxBottom.getChildren().addAll((Object[])new Node[]{this.checkColor, this.checkSound, this.checkGravity, this.spacePause});
        this.borderPane = new BorderPane();
        this.borderPane.getStyleClass().add((Object)"background");
        this.borderPane.setTop((Node)this.vboxTop);
        this.borderPane.setBottom((Node)this.vboxBottom);
        this.stackPane = new StackPane();
        this.stackPane.getChildren().add((Object)this.tetrisGrid);
        this.root = new HBox();
        this.root.getStyleClass().add((Object)"background");
        this.root.setPadding(new Insets(5.0));
        this.root.setSpacing(25.0);
        this.root.getChildren().addAll((Object[])new Node[]{this.borderPane, this.stackPane});
        this.pauseImg = new ImageView(new Image(((Object)((Object)this)).getClass().getResource("/resources/pause.png").toExternalForm()));
        this.pauseCenter = new BorderPane();
        this.pauseCenter.setCenter((Node)this.pauseImg);
        this.boardShade = new Rectangle(318.0, 702.0);
        this.boardShade.setOpacity(0.5);
        this.boardShade.setFill((Paint)Color.BLACK);
        this.boardShade.toFront();
        this.scene = new Scene((Parent)this.root);
        this.scene.getStylesheets().add((Object)((Object)((Object)this)).getClass().getResource("/resources/application.css").toExternalForm());
        this.scene.setOnKeyReleased(ke -> {
            this.pressed = true;
        });
        this.scene.setOnKeyPressed(ke -> {
            if (this.running) {
                if (ke.getCode().equals((Object)KeyCode.LEFT) || ke.getCode().equals((Object)KeyCode.A)) {
                    this.board.moveLeft();
                    this.paint();
                } else if (ke.getCode().equals((Object)KeyCode.DOWN) || ke.getCode().equals((Object)KeyCode.S)) {
                    this.board.moveDown();
                    this.paint();
                } else if (ke.getCode().equals((Object)KeyCode.RIGHT) || ke.getCode().equals((Object)KeyCode.D)) {
                    this.board.moveRight();
                    this.paint();
                } else if ((ke.getCode().equals((Object)KeyCode.UP) || ke.getCode().equals((Object)KeyCode.W)) && this.pressed) {
                    this.pressed = false;
                    this.board.rotate();
                    this.paint();
                }
            }
            if (ke.getCode().equals((Object)KeyCode.SPACE)) {
                if (this.gameOver) {
                    this.shapeTransition.stop();
                    this.startNewGame();
                    this.board.setGravity(this.checkGravity.isSelected());
                    this.stackPane.getChildren().removeAll((Object[])new Node[]{this.boardShade, this.gameOverCenter});
                } else if (this.running) {
                    this.running = false;
                    this.stopMusic();
                    this.shapeTransition.stop();
                    this.stackPane.getChildren().addAll((Object[])new Node[]{this.boardShade, this.pauseCenter});
                } else {
                    this.running = true;
                    this.playMusic();
                    this.shapeTransition.play();
                    this.stackPane.getChildren().removeAll((Object[])new Node[]{this.boardShade, this.pauseCenter});
                }
                this.setSceneDisable(!this.running);
            }
        });
        this.startNewGame();
        this.stage = primaryStage;
        this.stage.setScene(this.scene);
        this.stage.setTitle("Tetris");
        this.stage.show();
    }

    public void startNewGame() {
        this.board = new Board();
        this.running = true;
        this.gameOver = false;
        this.pressed = true;
        this.shapeSpeed = this.board.getTimePerBlock();
        this.paint();
        this.createTransition();
        this.playMusic();
        this.soundEffectPlayer.stop();
        this.soundEffectPlayer.seek(Duration.ZERO);
        this.mainThemePlayer.seek(Duration.ZERO);
    }

    public void createTransition() {
        this.shapeSpeed = this.board.getTimePerBlock();
        this.shapeTransition = new SequentialTransition();
        this.pauseTransition = new PauseTransition(Duration.millis((double)this.shapeSpeed));
        this.pauseTransition.setOnFinished(evt -> {
            this.board.moveDown();
            this.paint();
        });
        this.shapeTransition.getChildren().add((Object)this.pauseTransition);
        this.shapeTransition.setCycleCount(-1);
        this.shapeTransition.play();
    }

    public void playMusic() {
        if (this.checkSound.isSelected()) {
            this.mainThemePlayer.play();
            this.mainThemePlayer.setVolume(0.0);
            this.musicTimeline = new Timeline(new KeyFrame[]{new KeyFrame(Duration.millis((double)400.0), new KeyValue[]{new KeyValue((WritableValue)this.mainThemePlayer.volumeProperty(), (Object)1)})});
            this.musicTimeline.play();
        }
    }

    public void stopMusic() {
        this.musicTimeline = new Timeline(new KeyFrame[]{new KeyFrame(Duration.millis((double)200.0), new KeyValue[]{new KeyValue((WritableValue)this.mainThemePlayer.volumeProperty(), (Object)0)})});
        this.musicTimeline.setOnFinished(evt -> this.mainThemePlayer.pause());
        this.musicTimeline.play();
    }

    public void setSceneDisable(boolean value) {
        this.level.setDisable(value);
        this.score.setDisable(value);
        this.line.setDisable(value);
        this.subLevel.setDisable(value);
        this.subScore.setDisable(value);
        this.subLine.setDisable(value);
        this.checkColor.setDisable(value);
        this.checkGravity.setDisable(value);
        this.checkSound.setDisable(value);
        this.spacePause.setDisable(value);
    }

    public static void main(String[] args) {
        Main.launch((String[])args);
    }
}

