/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.List;

class Shape {
    private int type;
    private int rotation;
    private List<Point> points;

    public Shape(int num) {
        this.type = num;
        this.rotation = 0;
        this.points = new ArrayList<Point>();
        this.createPoints();
    }

    public Shape(Shape shape) {
        this.type = shape.type;
        this.rotation = shape.rotation;
        this.points = new ArrayList<Point>(shape.points.size());
        for (Point i : shape.points) {
            this.points.add(new Point(i.getX(), i.getY(), this.type));
        }
    }

    private void createPoints() {
        if (this.type != 7 && this.type != 4 && this.type != 1 && this.type != 3) {
            this.points.add(new Point(3, 0, this.type));
        }
        if (this.type != 1 && this.type != 6) {
            this.points.add(new Point(4, 0, this.type));
        }
        if (this.type != 5 && this.type != 6 && this.type != 3) {
            this.points.add(new Point(5, 0, this.type));
        }
        if (this.type == 2) {
            this.points.add(new Point(6, 0, this.type));
        } else {
            this.points.add(new Point(4, 1, this.type));
        }
        if (this.type != 4 && this.type != 2) {
            this.points.add(new Point(5, 1, this.type));
        }
        if (this.type == 1 || this.type == 4 || this.type == 6 || this.type == 3) {
            this.points.add(new Point(3, 1, this.type));
        }
    }

    public void moveDown() {
        for (Point i : this.points) {
            i.modY(1);
        }
    }

    public void moveLeft() {
        for (Point i : this.points) {
            i.modX(-1);
        }
    }

    public void moveRight() {
        for (Point i : this.points) {
            i.modX(1);
        }
    }

    public void rotate() {
        if (this.type != 7) {
            int lowX = 100;
            int lowY = 100;
            for (Point i : this.points) {
                if (i.getX() < lowX) {
                    lowX = i.getX();
                }
                if (i.getY() >= lowY) continue;
                lowY = i.getY();
            }
            if (this.type == 2) {
                for (Point i : this.points) {
                    if (this.rotation == 0) {
                        i.setLocation(i.getY() - lowY + lowX + 2, i.getX() - lowX + lowY - 1);
                        continue;
                    }
                    if (this.rotation == 1) {
                        i.setLocation(i.getY() - lowY + lowX - 2, i.getX() - lowX + lowY + 2);
                        continue;
                    }
                    if (this.rotation == 2) {
                        i.setLocation(i.getY() - lowY + lowX + 1, i.getX() - lowX + lowY - 2);
                        continue;
                    }
                    i.setLocation(i.getY() - lowY + lowX - 1, i.getX() - lowX + lowY + 1);
                }
            } else {
                for (Point i : this.points) {
                    if (this.rotation == 1 || this.rotation == 2) {
                        i.setLocation(2 - (i.getY() - lowY) + lowX - 1, i.getX() - lowX - 1 + this.rotation % 2 * 2 + lowY);
                        continue;
                    }
                    i.setLocation(2 - (i.getY() - lowY) + lowX, i.getX() - lowX + lowY);
                }
            }
        }
        this.rotation = (this.rotation + 1) % 4;
    }

    public List<Point> getRotatePoints() {
        Shape rotated = new Shape(this);
        rotated.rotate();
        return rotated.points;
    }

    public int getType() {
        return this.type;
    }

    public List<Point> getPoints() {
        return this.points;
    }

    public String toString() {
        String str = "";
        for (Point i : this.points) {
            str = String.valueOf(str) + "x:" + i.getX() + " y: " + i.getY() + "\n";
        }
        return str;
    }
}

